/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* @(#)99	1.3  src/avs/fs/mmfs/ts/kernext/ibm-linux/lxtrace.h, mmfs, avs_remp, rempt1d1 4/24/01 16:28:48 */

#ifndef _h_lxtrace
#define _h_lxtrace

/*
 * Interfaces to the Linux kernel trace device
 *
 * $Id: lxtrace.h,v 1.3 2001/04/24 18:13:43 wyllie Exp $
 *
 * $Log: lxtrace.h,v $
 * Revision 1.3  2001/04/24 18:13:43  wyllie
 * Move handle of the trace file out of the shared segment.
 *
 * Revision 1.2  2001/01/27 20:37:50  dcraft
 * Move trace device header definition so it can be used by lcrash
 *
 * Revision 1.1  2000/11/02 14:46:46  dixonbp
 * Rename ltrace to lxtrace (including related defines and structs) to
 * avoid confusion with the existing linux ltrace (library trace) command.
 *
 * Revision 1.2  2000/10/27  01:46:22  wyllie
 * Clean up ltrace: Fix _STrace of string arguments that are not the last
 * parameter.  Check for buffer overflow when building S or X type traces.
 * Shorten header in trace file by eliminating and combining fields.  Make
 * sure strings in trace file are null-terminated.  Round string lengths to
 * a multiple of the word size.
 *
 * Revision 1.1  2000/10/25  16:54:40  wyllie
 * Trace include reorganization: split old tasking/Trace.h into five new
 * files, and move most of them into directories that will be shipped with
 * GPFS on Linux.  Also change the code in trcid.h files generated by
 * mktrace to not include AIX specific stuff like direct use of AIX trace
 * macros.  Change names of all macros in generated code to have a leading
 * underscore.  As a result of these changes, all trcid.h files had to
 * be rebuilt.
 *
 */

#ifndef _LINUX_TIME_H
#include <sys/time.h>
#endif

/* Size of the ioctl trc_dump output buffer */
#define LXTRACE_DUMP_SIZE 512

/* The maximum number of trace hook types that can be traced */
#define LXTRACE_MAX_HW 8
#define LXTRACE_HW_MAX_DIGITS 3
/* comma-separated hooks */
#define LXTRACE_HW_STRING_LEN (LXTRACE_MAX_HW*(LXTRACE_HW_MAX_DIGITS+1))
#define LXTRACE_MAX_DATA 512
#define LXTRACE_MAGIC 0xACE98271

/* Number of "$n" substitutions supported in a single trace record */
#define LXTRACE_MAX_FORMAT_SUBS 12


/* Definitions of the trace record format */
typedef struct
{
  uint trMagic;         /* Magic number to allow resynch after trace
                           wraparound */
  struct timeval trTime;/* Timestamp of trace record */
  pid_t trProcess;      /* ID of process making the trace */
  short trCPU;          /* CPU number of process making the trace */
  short trLength;       /* Number of bytes that follow, consisting of a
                           trc_datahdr_t followed by the application
                           data */
} trc_header_t;
/* Followed by the application trace data "char data[Length]" */

/* The following device operations are supported for the trace device:
    trc_open     Prepare the device for tracing 
    trc_ioctl    Device control operation (see the trace_op definition)
    trc_read     Allows the daemon to retrieve the trace records 
    trc_write    Trace records are writen to the device 
    trc_fsync    Sync all buffered data to the daemon 
    trc_close    Terminate tracing and close the device 
*/

/* Device ioctl operations */
typedef enum
{
  trc_begin,    /* Enable tracing for the specified trace types */
  trc_end,      /* Fence new writes in preparation for close */
  trc_bufSize,  /* Change the device buffer size */
  trc_dump      /* Dump trace state information */
} trace_op;

/* Structure for passing parameters to the trace device through ioctls */
struct kArgs
{
  long arg1;
  long arg2;
  long arg3;
  long arg4;
  long arg5;
};


#ifdef __cplusplus
extern "C"
{
#endif
int trc_fsync();
#ifdef __cplusplus
}
#endif


/* Allowable file sizes for the lxtrace command */
#define MIN_TRC_FILESIZE 1*1024*1024
#define DEF_TRC_FILESIZE 16*1024*1024
#define MAX_TRC_FILESIZE 1024*1024*1024

/* Allowable buffer sizes for the lxtrace command.  Two buffers of this
   size will be allocated. */
#define MIN_TRC_BUFSIZE 4096
#define DEF_TRC_BUFSIZE 64*1024
#define MAX_TRC_BUFSIZE 1024*1024

/* Trace device name */
#define TRC_DEVICE "/dev/trace0"

/* Header of a trace record to be passed to the trace device */
typedef struct
{
  uint trHook;          /* Trace hook word that uniquely identifies the
                           format of this trace record */
  char trNArgs;         /* Number of integer arguments.  Each argument is as
                           long as the word width of the machine.  Does not
                           count string, generic, or float arguments. */
  unsigned char trSPos; /* Position of string argument within argument list.
                           May also take on special values to indicate all
                           integers or all integers followed by a float. */
  short trSLen;         /* If format is string or generic, contains the length
                           of the variable part, rounded up to a multiple
                           of the word size */
} trc_datahdr_t;
/* followed by char arg[LXTRACE_MAX_DATA-sizeof(trc_datahdr_t)] */


#ifdef __KERNEL__
/* Trace device structures */

/* Possible states of the trace device */
typedef enum trcdev_state_t
{
  trc_initialized,  /* header constructed */
  trc_registered,   /* device registered  */
  trc_opened,       /* device opened      */
  trc_active,       /* ready for tracing  */
  trc_stopped,      /* tracing disabled   */
  trc_closed,       /* device closed      */
  trc_unregistered  /* device unregistred */
} trcdev_state_t;

typedef struct trcdev_buffer_t
{
  char * beginP; /* first byte of the buffer */
  char * endP;   /* last byte of the buffer */
  char * nextP;  /* offset of next record to be read/written */
  char * dirtyP; /* offset of next byte to be read */
} trcdev_buffer_t;

typedef struct trcdev_header_t
{
  int major;                /* major number of the trace device */
  int minor;                /* minor number of the trace device */
  int bufSize;              /* number of bytes in the trace buffers */
  int nHooks;               /* number of trace hookids being traced */
  int hookP[LXTRACE_MAX_HW];/* the list of hooks being traced */
  int nOpens;               /* number of times the device is open */
  int nWaits;               /* number of times we had to wait for the daemon */
  int nBuffers;             /* number of buffers filled with trace data */
  int devWaiting;           /* non-zero when waiting for the daemon */
  trcdev_state_t state;     /* status of the trace device */
  trcdev_buffer_t writeBuf; /* The trace buffer being written */
  trcdev_buffer_t readBuf;  /* The buffer being read by the daemon */
} trcdev_header_t;
#endif /* __KERNEL __ */
#endif /* _h_lxtrace */
